/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;

public class ItemHandoverData
implements IQuestData {
    private final ItemStack[] items;

    public ItemHandoverData(ItemStack[] items) {
        this.items = items;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public String toString() {
        CharSequence[] itemArray = (String[])Arrays.stream(this.items).map(item -> String.format("%sx%s", item.func_190916_E(), item.func_151000_E().getString().replaceAll("[]\\[]", ""))).toArray(String[]::new);
        return String.format("ItemHandover - Items [ %s ]", String.join((CharSequence)", ", itemArray));
    }

    public static final class Serializer
    implements QuestType.IQuestDataResolver<ItemHandoverData> {
        @Override
        public ItemHandoverData resolve(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"items");
            ItemStack[] items = JsonHelper.deserializeInto(array, ItemStack[]::new, this::resolveItemStack);
            return new ItemHandoverData(items);
        }

        @Override
        public CompoundNBT serialize(ItemHandoverData data) {
            CompoundNBT nbt = new CompoundNBT();
            ListNBT list = new ListNBT();
            for (ItemStack stack : data.items) {
                CompoundNBT stackNbt = stack.serializeNBT();
                list.add((Object)stackNbt);
            }
            nbt.func_218657_a("items", (INBT)list);
            return nbt;
        }

        @Override
        public ItemHandoverData deserialize(CompoundNBT nbt) {
            ListNBT listNBT = nbt.func_150295_c("items", 10);
            ItemStack[] stacks = (ItemStack[])listNBT.stream().map(inbt -> {
                CompoundNBT itemNbt = (CompoundNBT)inbt;
                return ItemStack.func_199557_a((CompoundNBT)itemNbt);
            }).toArray(ItemStack[]::new);
            return new ItemHandoverData(stacks);
        }

        private ItemStack resolveItemStack(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonElement itemId = object.get("item");
            Item item = JsonHelper.resolveItem(itemId);
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            return new ItemStack((IItemProvider)item, count);
        }
    }
}

